/*------------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich edited by Jonas l.
 Remarks:        
 known Problems: none
 Version:        18.01.15
 Description:    DMX_3Kanal_Dimmer


 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
 GNU General Public License, wie von der Free Software Foundation verffentlicht, 
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder 
 (nach Ihrer Option) jeder spteren Version. 

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung, 
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
 Programm erhalten haben. 
 Falls nicht, schreiben Sie an die Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
------------------------------------------------------------------------------*/

#include <avr/interrupt.h>
#include <avr/io.h>
#include <stdio.h>

#define F_CPU 12000000

#define LED_R_PIN_OUT DDRD |= (1<<PD5);
#define LED_G_PIN_OUT DDRD |= (1<<PD4);
#define LED_B_PIN_OUT DDRD |= (1<<PD3);

//LED RGB hier richtig einstellen!
#define LED_R_ON		PORTD |= (1<<PD3);
#define LED_R_OFF		PORTD &= ~(1<<PD3);
#define LED_B_ON		PORTD |= (1<<PD5);
#define LED_B_OFF		PORTD &= ~(1<<PD5);
#define LED_G_ON		PORTD |= (1<<PD4);
#define LED_G_OFF		PORTD &= ~(1<<PD4);

#define LED_DMX_PIN_OUT DDRD |= (1<<PD1);
#define LED_DMX_ON PORTD |= (1<<PD1);
#define LED_DMX_OFF PORTD &= ~(1<<PD1);


#define DMX_BAUD 250000
#define DMX_LOST_TIMEOUT 8000

volatile unsigned int dmx_lost = DMX_LOST_TIMEOUT;

volatile unsigned int dmx_adresse = 0;
volatile unsigned char dmx_buffer[6];

volatile unsigned char led_kanal[3];
//############################################################################
//DMX Senderoutine
ISR (USART_RX_vect)
//############################################################################
{
	static unsigned int dmx_channel_rx_count = 0;
	static unsigned char dmx_valid = 0;
	unsigned char tmp = 0;
	
	tmp =  UDR;
	
	if(UCSRA&(1<<FE))
	{
		if(dmx_channel_rx_count > 1)
		{
			dmx_lost = 0;
		}
		dmx_channel_rx_count = 0;	
		dmx_buffer[0] = tmp;
		if(dmx_buffer[0] == 0)
		{
			dmx_valid = 1;
			dmx_channel_rx_count++;
		}
		else
		{
			dmx_valid = 0;
		}
		return;
	}
	
	if(dmx_valid)
	{
		if(dmx_channel_rx_count == dmx_adresse) dmx_buffer[1] = tmp;
		if(dmx_channel_rx_count == dmx_adresse+1) dmx_buffer[2] = tmp;
		if(dmx_channel_rx_count == dmx_adresse+2) dmx_buffer[3] = tmp;
		if(dmx_channel_rx_count == dmx_adresse+3) dmx_buffer[4] = tmp;
		if(dmx_channel_rx_count == dmx_adresse+4) dmx_buffer[5] = tmp;
		
		if(dmx_channel_rx_count < 514)
		{
			dmx_channel_rx_count++;
		}
		return;
	}
}

//############################################################################
//Hier wird die Zeit gezhlt (Tick 1ms)
ISR (TIMER0_COMPA_vect)
//############################################################################
{
	static unsigned char pwm_counter = 0;

	pwm_counter++;
	if(pwm_counter == 255)
	{
		pwm_counter = 0;
	}
	
	if(pwm_counter >= led_kanal[0]) 
	{
		LED_R_OFF;
	}
	else
	{
		LED_R_ON;
	}
	if(pwm_counter >= led_kanal[1])
	{
		LED_G_OFF;
	}
	else
	{
		LED_G_ON;
	}
	if(pwm_counter >= led_kanal[2]) 
	{
		LED_B_OFF;
	}
	else
	{
		LED_B_ON;
	}
	
	if(dmx_lost<DMX_LOST_TIMEOUT)
	{
		dmx_lost++;
	}
}

//############################################################################
//Hauptprogramm
int main (void) 
//############################################################################
{  
	unsigned int dmx_adresse_tmp;
	unsigned long strobe_counter = 0;
	unsigned char tmp1,tmp2,tmp3;

	//Init usart DMX-BUS
	UBRRH   = (unsigned char)(F_CPU / (DMX_BAUD * 16L) - 1)>>8;
	UBRRL   = (unsigned char)(F_CPU / (DMX_BAUD * 16L) - 1);
	UCSRB|=(1 << RXEN | 1<< RXCIE);
	UCSRC|=(1<<USBS); //USBS0 2 Stop bits	
	
	//Timer0 Timecounter fr DMX Ausfall und PWM
	TCCR0A |= (1<<WGM01);
	TCCR0B |= (1<<CS00);
	TIMSK |= (1<<OCIE0A);
	OCR0A = F_CPU/1024/100 - 1; //Tick 1ms
	
	//Pullup Wiederstnde aktivieren
	PORTB |= 0xFF;
	PORTD |= (1<<PD6);
	PORTD |= (1<<PD2);
	
	//LEDs als Ausgnge definieren
	LED_R_PIN_OUT;
	LED_G_PIN_OUT;
	LED_B_PIN_OUT;
	LED_DMX_PIN_OUT;
	
	LED_DMX_ON;
	for(unsigned long tmp = 0;tmp<500000;tmp++)asm("nop");
	LED_DMX_OFF;
	LED_R_ON;
	for(unsigned long tmp = 0;tmp<500000;tmp++)asm("nop");
	LED_R_OFF;
	LED_G_ON;
	for(unsigned long tmp = 0;tmp<500000;tmp++)asm("nop");
	LED_G_OFF;
	LED_B_ON;
	for(unsigned long tmp = 0;tmp<500000;tmp++)asm("nop");
	LED_B_OFF;
	
	sei();//Globale Interrupts Enable
	
	//Endlosschleife
	while(1)
	{
		//Wenn DIP 10 Aktiviert -> stand alone
		if (!(PIND&(1<<PD2)))
		{
			LED_DMX_OFF;
			led_kanal[0] = 0;
			led_kanal[1] = 0;
			led_kanal[2] = 0;
			if(!(PIND&(1<<PD6))) led_kanal[0] += 127;
			if(!(PINB&(1<<PB0))) led_kanal[0] += 127;
			if(!(PINB&(1<<PB1))) led_kanal[1] += 127;
			if(!(PINB&(1<<PB2))) led_kanal[1] += 127;
			if(!(PINB&(1<<PB3))) led_kanal[2] += 127;
			if(!(PINB&(1<<PB4))) led_kanal[2] += 127;
		}
		else
		{
			
		
		dmx_adresse_tmp = 0;
		
		if(!(PIND&(1<<PD6))) dmx_adresse_tmp |= 0x01;
				
		if(!(PINB&(1<<PB0))) dmx_adresse_tmp |= 0x02;
 		if(!(PINB&(1<<PB1))) dmx_adresse_tmp |= 0x04;
		if(!(PINB&(1<<PB2))) dmx_adresse_tmp |= 0x08;
		if(!(PINB&(1<<PB3))) dmx_adresse_tmp |= 0x10;
		if(!(PINB&(1<<PB4))) dmx_adresse_tmp |= 0x20;
		if(!(PINB&(1<<PB5))) dmx_adresse_tmp |= 0x40;
		if(!(PINB&(1<<PB6))) dmx_adresse_tmp |= 0x80;
		if(!(PINB&(1<<PB7))) dmx_adresse_tmp |= 0x0100;
		
		if(dmx_adresse != dmx_adresse_tmp) dmx_adresse =  dmx_adresse_tmp;
		
		if(dmx_lost==DMX_LOST_TIMEOUT)
		{
			//DMX Werte sollen gehalten werden wenn anderes gewnscht einfach wieder einkommentiern
			//dmx_buffer[1] = 0;
			//dmx_buffer[2] = 0;
			//dmx_buffer[3] = 0;
			//dmx_buffer[4] = 0;
			LED_DMX_OFF;
		}
		else LED_DMX_ON;
		
		tmp1 = dmx_buffer[1]*dmx_buffer[4]/255;
		tmp2 = dmx_buffer[2]*dmx_buffer[4]/255;
		tmp3 = dmx_buffer[3]*dmx_buffer[4]/255;
		
		
		if(dmx_buffer[5]<10)
		{
			led_kanal[0] = tmp1;
			led_kanal[1] = tmp2;
			led_kanal[2] = tmp3;
		}
		else
		{
			strobe_counter++;
			if(strobe_counter > (256 - dmx_buffer[5]))
			{
				led_kanal[0] = tmp1;
				led_kanal[1] = tmp2;
				led_kanal[2] = tmp3;
			}
			else
			{
				led_kanal[0] = 0;
				led_kanal[1] = 0;
				led_kanal[2] = 0;
			}
			
			if(strobe_counter > (2 * (256 - dmx_buffer[5])))
			{
				strobe_counter = 0;
				led_kanal[0] = 0;
				led_kanal[1] = 0;
				led_kanal[2] = 0;
			}
		}
		}
	}
}